uniform float amount<
    string label = "Amount (0.0)";
    string widget_type = "slider";
    float minimum = -50.0;
    float maximum = 50.0;
    float step = 0.01;
> = 0.0;

uniform float scroll<
    string label = "Scroll (0.0)";
    string widget_type = "slider";
    float minimum = -2000.0;
    float maximum = 2000.0;
    float step = 0.01;
> = 0.0;

uniform float res<
    string label = "Resolution (1.0)";
    string widget_type = "slider";
    float minimum = 1.0;
    float maximum = 720.0;
    float step = 0.01;
> = 1.0;

float rand(vec2 n) { 
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

float randinterp(vec2 n) {
    return mix(rand(vec2(n.x, floor(n.y))), rand(vec2(n.x, floor(n.y + 1.0))), fmod(n.y, 1.0));
}

float4 mainImage(VertData v_in) : TARGET {
    float a = v_in.uv.y * res + elapsed_time * scroll;
    v_in.uv.x -= (amount / 640.0) * randinterp(vec2(floor(a / 480.0), fmod(a, 480.0)));
    if (v_in.uv.x < 0.0 || v_in.uv.x > 1.0) {
        return float4(0.0, 0.0, 0.0, 0.0);
    }
    return image.Sample(textureSampler, v_in.uv);
}
