uniform float ysubmul<
    string label = "YUV Y noise multiplier (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.001;
> = 0.5;
uniform float usubmul<
    string label = "YUV U noise multiplier (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.001;
> = 0.5;
uniform float vsubmul<
    string label = "YUV V noise multiplier (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.001;
> = 0.5;

float4 rgb2yuv(float4 pix) {
    float4 yuv = float4(0.0, 0.0, 0.0, pix.a);
    yuv.x = pix.r * 0.299 + pix.g * 0.587 + pix.b * 0.114;
    yuv.y = pix.r * -0.169 + pix.g * -0.331 + pix.b * 0.5;
    yuv.z = pix.r * 0.5 + pix.g * -0.419 + pix.b * -0.081;
    return yuv;
}

float4 yuv2rgb(float4 yuv) {
    float4 rgb = float4(0.0, 0.0, 0.0, yuv.a);
    rgb.r = yuv.x + yuv.z * 1.4;
    rgb.g = yuv.x + yuv.y * -0.343 + yuv.z * -0.711;
    rgb.b = yuv.x + yuv.y * 1.765;
    return rgb;
}

float rand(float2 n) { 
    return fmod(fract(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453), 1.0) * 2.0 - 1.0;
}

float4 mainImage(VertData v_in) : TARGET {
    float4 yuv1 = rgb2yuv(image.Sample(textureSampler, v_in.uv));
    yuv1.x -= rand(float2(v_in.uv.y + rand_f + 1, v_in.uv.x + rand_f)) * ysubmul;
    yuv1.y -= rand(float2(v_in.uv.y + rand_f + 2, v_in.uv.x + rand_f)) * usubmul;
    yuv1.z -= rand(float2(v_in.uv.y + rand_f + 3, v_in.uv.x + rand_f)) * vsubmul;
    return yuv2rgb(yuv1);
}
